#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"

#include "game/level_update.h"

#include "levels/scripts.h"

#include "actors/common1.h"

#include "make_const_nonconst.h"
#include "levels/ttc/header.h"
#include "level_misc_macros.h"
#include "macro_preset_names.h"
static const MacroObject local_macro_objects_ttc_1[] = {
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_cube,16,64504,62245,1070,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_cube,32,63655,1767,65090,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_cube,32,63666,2068,362,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_cube,80,64766,61175,65113,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_cube,48,64222,61845,788,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_cube,48,64222,62644,1353,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_prism,112,780,5767,64509,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_prism,112,1063,5562,64792,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_pendulum,16,64186,748,64328,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_pendulum,16,64846,901,64626,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_pendulum,16,64147,62506,64508,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_pendulum,16,937,61669,64495,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_large_treadmill,48,65397,61128,64480,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_treadmill,32,618,3656,148,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_treadmill,96,963,3297,608,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_treadmill,32,1306,2939,1069,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_treadmill,112,64357,64083,64744,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,174,1248,2040,2),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,16,64215,1490,63973,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,16,64460,1730,63728,5),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,16,64217,1970,63972,10),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,65019,3175,2040,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,65366,1248,2040,1),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,65021,1248,2040,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,0,65361,64185,63497,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,65021,62946,2040,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,518,3175,2040,3),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,65365,3175,2040,1),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_push_block,64,174,3175,2040,2),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_hexagon,0,1490,63448,64663,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_hexagon,0,64828,63930,63947,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_hexagon,0,954,63909,64088,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_hexagon,0,1215,63755,64321,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_hexagon,0,1052,63602,64767,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_triangle,80,64916,1229,1233,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_triangle,112,1050,65517,64499,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_pit_block,112,64436,65465,64506,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_clock_hand,80,0,6011,0,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_clock_hand,16,0,63049,0,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,1102,61917,1682,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,32,424,62224,1959,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,1102,62532,1682,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,1584,62839,1200,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,1582,61917,1203,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,64774,4347,1047,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,32,424,61610,1959,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,1102,61303,1682,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,48,1102,60688,1682,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,32,424,60996,1959,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,112,64499,4244,772,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,0,1828,3835,65486,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,0,1459,3835,65179,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_spinner,0,1091,3835,64871,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_gear,0,1580,60682,64711,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_gear,0,63844,1022,64379,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_gear,0,2098,7007,2243,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_large_gear,0,1801,60693,64805,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_large_gear,0,64059,1044,64448,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_large_gear,0,2268,7030,2227,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,800,61136,1900,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,800,61836,1900,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,800,62536,1900,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,1780,62236,1000,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,1388,62236,1428,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,200,62536,2000,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,200,61836,2000,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_red_coin,0,200,61136,2000,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_1up_in_pole,0,64456,90,1575,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_elevator_platform,16,64357,445,1413,6),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_elevator_platform,112,64012,64082,1129,2),
MACRO_OBJECT_WITH_BEH_PARAM(macro_circling_amp,0,64556,64836,1450,1),
MACRO_OBJECT_WITH_BEH_PARAM(macro_blue_coin_switch,16,64333,65517,65366,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,0,20,64136,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,65286,20,63836,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,250,20,63836,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,0,20,63536,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,500,20,63536,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,65036,20,63536,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_heave_ho,0,880,65517,1160,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_fire_spitter,0,800,63076,160,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_coin_line_horizontal,16,64416,64716,1320,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_fire_spitter,0,64965,6020,64122,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_recovery_heart,0,620,60386,1540,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_1up_trigger,0,65016,1351,1919,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_1up_trigger,0,65371,1351,1919,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_1up_trigger,0,182,1351,1919,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_1up,0,657,1368,1879,3),
MACRO_OBJECT_WITH_BEH_PARAM(macro_circling_amp,0,64836,63186,64836,1),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_1up,0,1883,4150,550,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_recovery_heart,0,64203,350,1116,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_1up,16,64435,6316,64851,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_bobomb,0,1077,60714,638,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_bobomb,0,1683,60714,189,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_hidden_blue_coin,0,0,20,63836,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_rotating_hexagon,0,64516,1229,537,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_ten_coins,16,2350,5600,2350,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_ten_coins,0,0,4783,0,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_three_coins,16,64396,61816,63916,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_three_coins,16,840,63336,860,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_yellow_coin,0,64766,61736,65096,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_yellow_coin,0,64766,61836,65096,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_ten_coins,0,280,60616,1660,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_three_coins,16,1240,300,840,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_three_coins,16,520,300,1500,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_ten_coins,0,65136,3600,1880,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_three_coins,0,65496,4160,64256,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_three_coins,16,64376,2920,64696,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_box_ten_coins,16,64756,6316,64516,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_large_treadmill_2,16,1313,6190,1313,0),
MACRO_OBJECT_WITH_BEH_PARAM(macro_ttc_small_treadmill_2,0,1851,63048,65438,0),
MACRO_OBJECT_END(),
};

static const LevelScript script_func_local_1[] = {
    OBJECT(/*model*/ MODEL_NONE,   /*pos*/ -1080,  -840,  1573, /*angle*/ 0,   0, 0, /*behParam*/ 0x00560000, /*beh*/ bhvPoleGrabbing),
    OBJECT(/*model*/ MODEL_THWOMP, /*pos*/  1919,  6191,  1919, /*angle*/ 0, 225, 0, /*behParam*/ 0x00000000, /*beh*/ bhvThwomp2),
    RETURN(),
};

static const LevelScript script_func_local_2[] = {
    OBJECT_WITH_ACTS(/*model*/ MODEL_STAR,   /*pos*/ -1450, -1130, -1050, /*angle*/ 0,   0, 0, /*behParam*/ 0x00000000, /*beh*/ bhvStar,                 /*acts*/ ALL_ACTS),
    OBJECT_WITH_ACTS(/*model*/ MODEL_STAR,   /*pos*/ -1850,   300,  -950, /*angle*/ 0,   0, 0, /*behParam*/ 0x01000000, /*beh*/ bhvStar,                 /*acts*/ ALL_ACTS),
    OBJECT_WITH_ACTS(/*model*/ MODEL_STAR,   /*pos*/ -1300, -2250, -1300, /*angle*/ 0,   0, 0, /*behParam*/ 0x02000000, /*beh*/ bhvStar,                 /*acts*/ ALL_ACTS),
    OBJECT_WITH_ACTS(/*model*/ MODEL_STAR,   /*pos*/  2200,  7300,  2210, /*angle*/ 0,   0, 0, /*behParam*/ 0x03000000, /*beh*/ bhvStar,                 /*acts*/ ALL_ACTS),
    OBJECT_WITH_ACTS(/*model*/ MODEL_STAR,   /*pos*/ -1050,  2400,  -790, /*angle*/ 0,   0, 0, /*behParam*/ 0x04000000, /*beh*/ bhvStar,                 /*acts*/ ALL_ACTS),
    OBJECT_WITH_ACTS(/*model*/ MODEL_NONE,   /*pos*/  1815, -3200,   800, /*angle*/ 0,   0, 0, /*behParam*/ 0x05000000, /*beh*/ bhvHiddenRedCoinStar, /*acts*/ ALL_ACTS),
    RETURN(),
};

const LevelScript level_ttc_entry[] = {
    INIT_LEVEL(),
    LOAD_MIO0(        /*seg*/ 0x07, _ttc_segment_7SegmentRomStart, _ttc_segment_7SegmentRomEnd),
    LOAD_MIO0_TEXTURE(/*seg*/ 0x09, _machine_mio0SegmentRomStart, _machine_mio0SegmentRomEnd),
    LOAD_MIO0(        /*seg*/ 0x05, _group1_mio0SegmentRomStart, _group1_mio0SegmentRomEnd),
    LOAD_RAW(         /*seg*/ 0x0C, _group1_geoSegmentRomStart,  _group1_geoSegmentRomEnd),
    LOAD_MIO0(        /*seg*/ 0x08, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
    LOAD_RAW(         /*seg*/ 0x0F, _common0_geoSegmentRomStart,  _common0_geoSegmentRomEnd),
    ALLOC_LEVEL_POOL(),
    MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
    JUMP_LINK(script_func_global_1),
    JUMP_LINK(script_func_global_2),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_ROTATING_CUBE,     ttc_geo_000240),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_ROTATING_PRISM,    ttc_geo_000258),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_PENDULUM,          ttc_geo_000270),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_LARGE_TREADMILL,   ttc_geo_000288),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_SMALL_TREADMILL,   ttc_geo_0002A8),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_PUSH_BLOCK,        ttc_geo_0002C8),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_ROTATING_HEXAGON,  ttc_geo_0002E0),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_ROTATING_TRIANGLE, ttc_geo_0002F8),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_PIT_BLOCK,         ttc_geo_000310),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_PIT_BLOCK_UNUSED,  ttc_geo_000328),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_ELEVATOR_PLATFORM, ttc_geo_000340),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_CLOCK_HAND,        ttc_geo_000358),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_SPINNER,           ttc_geo_000370),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_SMALL_GEAR,        ttc_geo_000388),
    LOAD_MODEL_FROM_GEO(MODEL_TTC_LARGE_GEAR,        ttc_geo_0003A0),

    AREA(/*index*/ 1, ttc_geo_0003B8),
MACRO_OBJECTS(local_macro_objects_ttc_1),
WARP_NODE(241,6,2,103,0),
WARP_NODE(240,6,2,53,0),
WARP_NODE(10,14,1,10,0),
OBJECT_WITH_ACTS(0,1815,-3200,800,0,0,0,0x5000000, bhvHiddenRedCoinStar,63),
OBJECT_WITH_ACTS(122,-1050,2400,-790,0,0,0,0x4000000, bhvStar,63),
OBJECT_WITH_ACTS(122,2200,7300,2210,0,0,0,0x3000000, bhvStar,63),
OBJECT_WITH_ACTS(122,-1300,-2250,-1300,0,0,0,0x2000000, bhvStar,63),
OBJECT_WITH_ACTS(122,-1850,300,-950,0,0,0,0x1000000, bhvStar,63),
OBJECT_WITH_ACTS(122,-1450,-1130,-1050,0,0,0,0x0, bhvStar,63),
OBJECT_WITH_ACTS(88,1919,6191,1919,0,225,0,0x0, bhvThwomp2,31),
OBJECT_WITH_ACTS(0,-1080,-840,1573,0,0,0,0x560000, bhvPoleGrabbing,31),
OBJECT_WITH_ACTS(0,1417,-3822,-548,0,316,0,0xa0000, bhvSpinAirborneWarp,31),
        TERRAIN(/*terrainData*/ ttc_seg7_collision_level),
        SET_BACKGROUND_MUSIC(/*settingsPreset*/ 0x0001, /*seq*/ SEQ_LEVEL_SLIDE),
        TERRAIN_TYPE(/*terrainType*/ TERRAIN_STONE),
    END_AREA(),

    FREE_LEVEL_POOL(),
    MARIO_POS(/*area*/ 1, /*yaw*/ 316, /*pos*/ 1417, -4822, -548),
    CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
    CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
    CLEAR_LEVEL(),
    SLEEP_BEFORE_EXIT(/*frames*/ 1),
    EXIT(),
};
